<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:saxon="http://saxon.sf.net/"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:schold="http://www.ascc.net/xml/schematron"
                xmlns:iso="http://purl.oclc.org/dsdl/schematron"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:hl7="urn:hl7-org:v3"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                version="2.0"><!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. -->
<xsl:param name="archiveDirParameter"/>
   <xsl:param name="archiveNameParameter"/>
   <xsl:param name="fileNameParameter"/>
   <xsl:param name="fileDirParameter"/>
   <xsl:variable name="document-uri">
      <xsl:value-of select="document-uri(/)"/>
   </xsl:variable>

   <!--PHASES-->


<!--PROLOG-->
<xsl:output method="text"/>

   <!--XSD TYPES FOR XSLT2-->


<!--KEYS AND FUNCTIONS-->


<!--DEFAULT RULES-->


<!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->
<xsl:template match="*" mode="schematron-select-full-path">
      <xsl:apply-templates select="." mode="schematron-get-full-path"/>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->
<xsl:template match="*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">
            <xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>*:</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>[namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="preceding"
                    select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])"/>
      <xsl:text>[</xsl:text>
      <xsl:value-of select="1+ $preceding"/>
      <xsl:text>]</xsl:text>
   </xsl:template>
   <xsl:template match="@*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">@<xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>@*[local-name()='</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>' and namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-2-->
<!--This mode can be used to generate prefixed XPath for humans-->
<xsl:template match="node() | @*" mode="schematron-get-full-path-2">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="preceding-sibling::*[name(.)=name(current())]">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>
   <!--MODE: SCHEMATRON-FULL-PATH-3-->
<!--This mode can be used to generate prefixed XPath for humans 
	(Top-level element has index)-->
<xsl:template match="node() | @*" mode="schematron-get-full-path-3">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="parent::*">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>

   <!--MODE: GENERATE-ID-FROM-PATH -->
<xsl:template match="/" mode="generate-id-from-path"/>
   <xsl:template match="text()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/>
   </xsl:template>
   <xsl:template match="comment()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/>
   </xsl:template>
   <xsl:template match="processing-instruction()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.@', name())"/>
   </xsl:template>
   <xsl:template match="*" mode="generate-id-from-path" priority="-0.5">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:text>.</xsl:text>
      <xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/>
   </xsl:template>

   <!--MODE: GENERATE-ID-2 -->
<xsl:template match="/" mode="generate-id-2">U</xsl:template>
   <xsl:template match="*" mode="generate-id-2" priority="2">
      <xsl:text>U</xsl:text>
      <xsl:number level="multiple" count="*"/>
   </xsl:template>
   <xsl:template match="node()" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>n</xsl:text>
      <xsl:number count="node()"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="string-length(local-name(.))"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="translate(name(),':','.')"/>
   </xsl:template>
   <!--Strip characters--><xsl:template match="text()" priority="-1"/>

   <!--SCHEMA SETUP-->
<xsl:template match="/">
      <xsl:apply-templates select="/" mode="M3"/>
      <xsl:apply-templates select="/" mode="M4"/>
      <xsl:apply-templates select="/" mode="M5"/>
   </xsl:template>

   <!--SCHEMATRON PATTERNS-->


<!--PATTERN xmlTest op processing instructions anders dan xml Test op gekoppelde XML Schema's Elementen Attributen-->


	<!--RULE -->
<xsl:template match="*[count(ancestor::*)=0]" priority="1006" mode="M3">
      <xsl:variable name="unparsed" select="unparsed-text(document-uri(/))"/>
      <xsl:variable name="firstprocessinginstruction"
                    select="substring-after(substring-before($unparsed, '?&gt;'),'&lt;?')"/>
      <xsl:variable name="declaration"
                    select="if (starts-with($firstprocessinginstruction,'xml')) then ($firstprocessinginstruction) else ()"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(contains($declaration,' version=')) or matches($declaration, 'version=.1\.0.')"/>
         <xsl:otherwise>
            <xsl:message>xml: het XML-prologattribuut moet versie 1.0 zijn. (not(contains($declaration,' version=')) or matches($declaration, 'version=.1\.0.') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(contains($declaration,' encoding=')) or matches($declaration, 'encoding=.(utf-8)|(UTF-8).')"/>
         <xsl:otherwise>
            <xsl:message>xml: het XML-prologattribuut encoding moet worden weggelaten of expliciet "UTF-8" zijn. (not(contains($declaration,' encoding=')) or matches($declaration, 'encoding=.(utf-8)|(UTF-8).') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="/processing-instruction('nictiz') or not(contains($declaration,' standalone='))"/>
         <xsl:otherwise>
            <xsl:message>xml: het XML-prologattribuut standalone mag niet worden gebruikt. (/processing-instruction('nictiz') or not(contains($declaration,' standalone=')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(//processing-instruction()) = 0 or /processing-instruction('nictiz')"/>
         <xsl:otherwise>
            <xsl:message>xml: de XML-prolog is de enig toegestane processing instruction. Bijvoorbeeld koppelingen naar stylesheets zijn niet toegestaan. (count(//processing-instruction()) = 0 or /processing-instruction('nictiz') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M3"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="*[@xsi:schemaLocation]" priority="1004" mode="M3">

		<!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="/processing-instruction('nictiz') or not(.)"/>
         <xsl:otherwise>
            <xsl:message>xml: er mogen geen XML Schema's zijn gekoppeld. Gevonden '<xsl:text/>
               <xsl:value-of select="@xsi:schemaLocation"/>
               <xsl:text/>' (/processing-instruction('nictiz') or not(.) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M3"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="*[@xsi:noNamespaceSchemaLocation]" priority="1003" mode="M3">

		<!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="/processing-instruction('nictiz') or not(.)"/>
         <xsl:otherwise>
            <xsl:message>xml: er mogen geen XML Schema's zijn gekoppeld. Gevonden '<xsl:text/>
               <xsl:value-of select="@xsi:noNamespaceSchemaLocation"/>
               <xsl:text/>' (/processing-instruction('nictiz') or not(.) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M3"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="*[@*[normalize-space()='']]" priority="1000" mode="M3">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>xml: attributen moeten een waarde hebben (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M3"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M3"/>
   <xsl:template match="@*|node()" priority="-2" mode="M3">
      <xsl:apply-templates select="*" mode="M3"/>
   </xsl:template>

   <!--PATTERN -->
<xsl:template match="text()" priority="-1" mode="M4"/>
   <xsl:template match="@*|node()" priority="-2" mode="M4">
      <xsl:apply-templates select="*" mode="M4"/>
   </xsl:template>

   <!--PATTERN -->


	<!--RULE -->
<xsl:template match="hl7:MCCI_IN200101/hl7:id" priority="1024" mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn (not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: AGB-code moet 8 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef (not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue" select="@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: @extension moet een geldige interactie-id bevatten (not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:MCCI_IN200101/hl7:creationTime" priority="1023" mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-QTY: no uncertainty (not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-QTY: no history or updateMode (count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@nullFlavor or @value or *) and not(@nullFlavor and @value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-TS: null or value or child element in case of extension ((@nullFlavor or @value or *) and not(@nullFlavor and @value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="datatypeName" select="substring-after(string(@xsi:type),':')"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@xsi:type) or string(@xsi:type)='TS' or substring-after(string(@xsi:type),':')='TS'"/>
         <xsl:otherwise>
            <xsl:message>Batch: creationTime moet datatype TS hebben. Gevonden '<xsl:text/>
               <xsl:value-of select="$datatypeName"/>
               <xsl:text/>' (not(@xsi:type) or string(@xsi:type)='TS' or substring-after(string(@xsi:type),':')='TS' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length(@value)&gt;13"/>
         <xsl:otherwise>
            <xsl:message>Batch: creationTime moet minimaal op de seconde nauwkeurig zijn (string-length(@value)&gt;13 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:MCCI_IN200101/hl7:versionCode" priority="1022" mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CS: @code/@typeCode and @nullFlavor are mutually exclusive ((@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystem)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CS: cannot have codeSystem (not(@codeSystem) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CS: cannot have codeSystemName (not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CS: cannot have codeSystemVersion (not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CS: cannot have displayName (not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CS: cannot have originalText (not(hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CS: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CS: cannot have translation (not(hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@code='NICTIZEd2005-Okt'"/>
         <xsl:otherwise>
            <xsl:message>Batch: versionCode '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' moet 'NICTIZEd2005-Okt' zijn (@code='NICTIZEd2005-Okt' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:MCCI_IN200101/hl7:interactionId" priority="1021" mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn (not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: AGB-code moet 8 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef (not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue" select="@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: @extension moet een geldige interactie-id bevatten (not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@root='2.16.840.1.113883.1.6' and @extension='MCCI_IN200101'"/>
         <xsl:otherwise>
            <xsl:message>Batch: @root moet '2.16.840.1.113883.1.6' zijn en @extension moet 'MCCI_IN200101' zijn (@root='2.16.840.1.113883.1.6' and @extension='MCCI_IN200101' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:MCCI_IN200101/hl7:profileId" priority="1020" mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn (not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: AGB-code moet 8 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef (not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue" select="@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: @extension moet een geldige interactie-id bevatten (not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@root='2.16.840.1.113883.2.4.3.11.1' and (@extension='810')"/>
         <xsl:otherwise>
            <xsl:message>Batch: profileId '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' moet gelijk zijn aan 810.  (@root='2.16.840.1.113883.2.4.3.11.1' and (@extension='810') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(following-sibling::hl7:profileId)"/>
         <xsl:otherwise>
            <xsl:message>Batch: er mag maar één profileId worden gebruikt (not(following-sibling::hl7:profileId) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:MCCI_IN200101/hl7:referenceControlId" priority="1019" mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn (not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: AGB-code moet 8 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef (not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue" select="@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: @extension moet een geldige interactie-id bevatten (not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <xsl:message>Batch: <xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="local-name()"/>
               <xsl:text/> mag niet worden gebruikt (false() / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:MCCI_IN200101/hl7:name" priority="1018" mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or count(*)&gt;0  or text()[string-length(normalize-space())&gt;0]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-BIN: there must be a nullFlavor, or content must be non-empty (@nullFlavor or count(*)&gt;0 or text()[string-length(normalize-space())&gt;0] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@integrityCheck) or @integrityCheckAlgorithm"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-ED: integrityCheckAlgorithm required if integrityCheck (not(@integrityCheck) or @integrityCheckAlgorithm / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-ED: thumbnails not null and reference (not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-ED: thumbnails do not have thumbnails (not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-ED: compression only on binary ((@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-ED: value implies mediaType is text/plain (not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-ED: no history or updateMode (count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@value or xml) or not(@charset)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-ED: no charset for value or xml (not(@value or xml) or not(@charset) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-9-ED: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@mediaType))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-ED: no mediaType if null (not(@nullFlavor) or (@nullFlavor and not(@mediaType)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@charset))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-11-ED: no charset if null (not(@nullFlavor) or (@nullFlavor and not(@charset)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@language))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-ED: no language if null (not(@nullFlavor) or (@nullFlavor and not(@language)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@compression))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-ED: no compression if null (not(@nullFlavor) or (@nullFlavor and not(@compression)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@integrityCheck))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-14-ED: no integrityCheck if null (not(@nullFlavor) or (@nullFlavor and not(@integrityCheck)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@integrityCheckAlgorithm))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-15-ED: no integrityCheckAlgorithm if null (not(@nullFlavor) or (@nullFlavor and not(@integrityCheckAlgorithm)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-16-ED: no thumbnail if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(hl7:translation))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-17-ED: no translation if null (not(@nullFlavor) or (@nullFlavor and not(hl7:translation)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="mediaType" select="@mediaType"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@mediaType) or document('../vocab/ED-mediaType.xml')/*/hl7:code[@code=$mediaType]"/>
         <xsl:otherwise>
            <xsl:message>Datatype ED: unsupported mediaType value
        '<xsl:text/>
               <xsl:value-of select="$mediaType"/>
               <xsl:text/>' (not(@mediaType) or document('../vocab/ED-mediaType.xml')/*/hl7:code[@code=$mediaType] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(thumbnail)"/>
         <xsl:otherwise>
            <xsl:message>Datatype ED: thumbnail is in Nederland vooralsnog niet toegestaan (not(thumbnail) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ST: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-SC: code requires codeSystem (@codeSystem or not(@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-SC: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-SC: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@code or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-SC: displayName only if code (@code or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@code))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-SC: no code if null (not(@nullFlavor) or (@nullFlavor and not(@code)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-SC: no displayName if null (not(@nullFlavor) or (@nullFlavor and not(@displayName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))">
         <xsl:message>Datatype CD: waarschuwing: onbekend codeSystem '<xsl:text/>
            <xsl:value-of select="@codeSystem"/>
            <xsl:text/>' gevonden met codeSystemName 
        '<xsl:text/>
            <xsl:value-of select="./@codeSystemName"/>
            <xsl:text/>'. Bestand '<xsl:text/>
            <xsl:value-of select="concat('../vocab/',@codeSystem,'.xml')"/>
            <xsl:text/>' ontbreekt. (@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml'))) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <xsl:message>Batch: <xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="local-name()"/>
               <xsl:text/> mag niet worden gebruikt (false() / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:MCCI_IN200101/hl7:batchComment" priority="1017" mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or count(*)&gt;0  or text()[string-length(normalize-space())&gt;0]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-BIN: there must be a nullFlavor, or content must be non-empty (@nullFlavor or count(*)&gt;0 or text()[string-length(normalize-space())&gt;0] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@integrityCheck) or @integrityCheckAlgorithm"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-ED: integrityCheckAlgorithm required if integrityCheck (not(@integrityCheck) or @integrityCheckAlgorithm / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-ED: thumbnails not null and reference (not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-ED: thumbnails do not have thumbnails (not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-ED: compression only on binary ((@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-ED: value implies mediaType is text/plain (not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-ED: no history or updateMode (count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@value or xml) or not(@charset)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-ED: no charset for value or xml (not(@value or xml) or not(@charset) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-9-ED: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@mediaType))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-ED: no mediaType if null (not(@nullFlavor) or (@nullFlavor and not(@mediaType)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@charset))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-11-ED: no charset if null (not(@nullFlavor) or (@nullFlavor and not(@charset)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@language))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-ED: no language if null (not(@nullFlavor) or (@nullFlavor and not(@language)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@compression))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-ED: no compression if null (not(@nullFlavor) or (@nullFlavor and not(@compression)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@integrityCheck))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-14-ED: no integrityCheck if null (not(@nullFlavor) or (@nullFlavor and not(@integrityCheck)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@integrityCheckAlgorithm))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-15-ED: no integrityCheckAlgorithm if null (not(@nullFlavor) or (@nullFlavor and not(@integrityCheckAlgorithm)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-16-ED: no thumbnail if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(hl7:translation))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-17-ED: no translation if null (not(@nullFlavor) or (@nullFlavor and not(hl7:translation)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="mediaType" select="@mediaType"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@mediaType) or document('../vocab/ED-mediaType.xml')/*/hl7:code[@code=$mediaType]"/>
         <xsl:otherwise>
            <xsl:message>Datatype ED: unsupported mediaType value
        '<xsl:text/>
               <xsl:value-of select="$mediaType"/>
               <xsl:text/>' (not(@mediaType) or document('../vocab/ED-mediaType.xml')/*/hl7:code[@code=$mediaType] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(thumbnail)"/>
         <xsl:otherwise>
            <xsl:message>Datatype ED: thumbnail is in Nederland vooralsnog niet toegestaan (not(thumbnail) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ST: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <xsl:message>Batch: <xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="local-name()"/>
               <xsl:text/> mag niet worden gebruikt (false() / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:MCCI_IN200101/hl7:transmissionQuantity" priority="1016" mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-QTY: no uncertainty (not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-QTY: no history or updateMode (count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@nullFlavor or @value or *) and not(@nullFlavor and @value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-INT: null or value or child element in case of extension ((@nullFlavor or @value or *) and not(@nullFlavor and @value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:uncertainty)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-INT: no uncertainty (not(hl7:uncertainty) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="messageCount" select="count(../hl7:sender/following-sibling::*)"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="number(@value) = $messageCount"/>
         <xsl:otherwise>
            <xsl:message>Batch: <xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="local-name()"/>
               <xsl:text/> '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' moet 
                overeenkomen met het aantal berichten '<xsl:text/>
               <xsl:value-of select="$messageCount"/>
               <xsl:text/>' (number(@value) = $messageCount / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:MCCI_IN200101/hl7:acknowledgement" priority="1015" mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@typeCode='AA'"/>
         <xsl:otherwise>
            <xsl:message>Batch: @typeCode moet 'AA' zijn (@typeCode='AA' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:targetMessage/hl7:id[@root and @extension] or hl7:targetTransmission/hl7:id[@root and @extension]"/>
         <xsl:otherwise>
            <xsl:message>Batch: in antwoordinteracties moet de interactie waarop wordt geantwoord, worden geïdentificeerd in het element targetTransmission/id (hl7:targetMessage/hl7:id[@root and @extension] or hl7:targetTransmission/hl7:id[@root and @extension] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:MCCI_IN200101/hl7:acknowledgement/hl7:acknowledgementDetail"
                 priority="1014"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <xsl:message>Batch: <xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="local-name()"/>
               <xsl:text/> is niet van toepassing in een positieve bevestiging (false() / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:MCCI_IN200101/hl7:receiver" priority="1013" mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@typeCode) or @typeCode='RCV'"/>
         <xsl:otherwise>
            <xsl:message>Batch: receiver/@typeCode moet 'RCV' zijn indien aanwezig (not(@typeCode) or @typeCode='RCV' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(../hl7:receiver)=1"/>
         <xsl:otherwise>
            <xsl:message>Batch: receiver mag slechts éénmaal voorkomen (count(../hl7:receiver)=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:MCCI_IN200101/hl7:receiver/hl7:device/hl7:id" priority="1012"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn (not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: AGB-code moet 8 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef (not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue" select="@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: @extension moet een geldige interactie-id bevatten (not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@root='2.16.840.1.113883.2.4.6.6' and not(@extension='1')"/>
         <xsl:otherwise>
            <xsl:message>De ontvanger van deze interactie moet een AORTA applicatie zijn, en kan niet de ZIM zijn (@root='2.16.840.1.113883.2.4.6.6' and not(@extension='1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:MCCI_IN200101/hl7:respondTo" priority="1011" mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <xsl:message>Batch: <xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="local-name()"/>
               <xsl:text/> mag niet worden gebruikt (false() / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:MCCI_IN200101/hl7:sender" priority="1010" mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@typeCode) or @typeCode='SND'"/>
         <xsl:otherwise>
            <xsl:message>Batch: sender/@typeCode moet 'SND' zijn indien aanwezig (not(@typeCode) or @typeCode='SND' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:MCCI_IN200101/hl7:sender/hl7:device/hl7:id" priority="1009"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn (not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: AGB-code moet 8 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef (not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue" select="@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: @extension moet een geldige interactie-id bevatten (not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@root='2.16.840.1.113883.2.4.6.6' and @extension='1'"/>
         <xsl:otherwise>
            <xsl:message>De zender van deze interactie moet de ZIM zijn (@root='2.16.840.1.113883.2.4.6.6' and @extension='1' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:MCCI_IN200101/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:desc"
                 priority="1008"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>Batch: <xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/device/descr mag niet gebruikt worden. (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:MCCI_IN200101/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:existenceTime"
                 priority="1007"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>Batch: <xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/device/existenceTime mag niet gebruikt worden. (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:MCCI_IN200101/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:manufacturerModelName"
                 priority="1006"
                 mode="M5">

		<!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>Batch: <xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/device/manufacturerModelName niet gebruiken. (not(.) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:MCCI_IN200101/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:agencyFor"
                 priority="1005"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@classCode) or @classCode='AGNT'"/>
         <xsl:otherwise>
            <xsl:message>Batch: <xsl:text/>
               <xsl:value-of select="local-name(../..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/agencyFor/@classCode moet, indien aanwezig de waarde "AGNT" bevatten (not(@classCode) or @classCode='AGNT' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:MCCI_IN200101/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:agencyFor/hl7:representedOrganization"
                 priority="1004"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@classCode) or @classCode='ORG'"/>
         <xsl:otherwise>
            <xsl:message>Batch: <xsl:text/>
               <xsl:value-of select="local-name(../../..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="local-name(../..)"/>
               <xsl:text/>/agencyFor/representedOrganization/@classCode moet, indien aanwezig de waarde "ORG" bevatten (not(@classCode) or @classCode='ORG' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@determinerCode) or @determinerCode='INSTANCE'"/>
         <xsl:otherwise>
            <xsl:message>Batch: <xsl:text/>
               <xsl:value-of select="local-name(../../..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="local-name(../..)"/>
               <xsl:text/>/agencyFor/representedOrganization/@determinerCode moet, indien aanwezig de waarde "INSTANCE" bevatten (not(@determinerCode) or @determinerCode='INSTANCE' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(hl7:id)=1"/>
         <xsl:otherwise>
            <xsl:message>Batch: <xsl:text/>
               <xsl:value-of select="local-name(../../..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="local-name(../..)"/>
               <xsl:text/>/agencyFor/representedOrganization/id mag maar één maal voorkomen (count(hl7:id)=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:MCCI_IN200101/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:agencyFor/hl7:representedOrganization/hl7:id"
                 priority="1003"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn (not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: AGB-code moet 8 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef (not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue" select="@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: @extension moet een geldige interactie-id bevatten (not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@root='2.16.528.1.1007.3.3' and @extension) or (@root='2.16.840.1.113883.2.4.3.11' and @extension='7')"/>
         <xsl:otherwise>
            <xsl:message>Batch: <xsl:text/>
               <xsl:value-of select="local-name(../../../..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="local-name(../../..)"/>
               <xsl:text/>/agencyFor/representedOrganization/id moet een UZI-registerabonneenummer zijn of het Klantenloket ((@root='2.16.528.1.1007.3.3' and @extension) or (@root='2.16.840.1.113883.2.4.3.11' and @extension='7') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:MCCI_IN200101/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:agencyFor/hl7:representedOrganization/hl7:name"
                 priority="1002"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-EN: entity name shall be null or text only or element only (no mixed content) (@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="*[not(@nullFlavor)][normalize-space(.)='']">
         <xsl:message>dtr1-3-EN: empty name particles should not be present. (*[not(@nullFlavor)][normalize-space(.)=''] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="substring(normalize-space(.),1,1)='&#34;'">
         <xsl:message>dtr1-4-EN: Use of quotes at the beginning of a name are probably not correct. (substring(normalize-space(.),1,1)='"' / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(hl7:family)=0 and count(hl7:given)=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ON: no parts may be person name type particles (count(hl7:family)=0 and count(hl7:given)=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(*)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-ON: organization names SHALL be element content (not(*) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:MCCI_IN200101/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:agencyFor/hl7:representedOrganization/hl7:telecom"
                 priority="1001"
                 mode="M5">
      <xsl:variable name="urlScheme" select="substring-before(@value,':')"/>
      <xsl:variable name="urlStr" select="substring-after(@value,':')"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-URL: elements of type URL SHALL have a @value attribute. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value=iri-to-uri(@value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-URL: @value must be a valid URI, e.g. '<xsl:text/>
               <xsl:value-of select="iri-to-uri(@value)"/>
               <xsl:text/>'. (@value=iri-to-uri(@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: Telecom elementen moeten een value attribuut hebben. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value=iri-to-uri(@value)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: Een telecom value moet een geldige URI zijn, bijvoorbeeld '<xsl:text/>
               <xsl:value-of select="iri-to-uri(@value)"/>
               <xsl:text/>'. (@value=iri-to-uri(@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="urlScheme" select="substring-before(@value,':')"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value and document('../vocab/URL-urlScheme.xml')/*/hl7:code[@code=$urlScheme]"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: Telecom value moet een in Nederland geldig URL scheme hebben. Gevonden '<xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/>' (@value and document('../vocab/URL-urlScheme.xml')/*/hl7:code[@code=$urlScheme] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="urlStr" select="substring-after(@value,':')"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='tel' or $urlScheme='fax') then (         matches($urlStr,'^(\+?([\d()./-]|(%[a-f\d]{2}))+)*(;(phone-context=((\+?([\d()./-]|(%[a-f\d]{2}))+)|(([a-z\d-]|(%[a-f\d]{2}))+(\.([a-z\d-]|(%[a-f\d]{2}))+)*))|(ext=[\d./-]+)|(isub=(([a-z\d();/?:@&amp;=+$,_.!~*-])|(%[a-f\d]{2}))+)|([a-z\d-]+=([a-z\d\[\]/:&amp;+$_.!~*()-]|(%[a-f\d]{2}))+)))*$')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 3966 (if ($urlScheme='tel' or $urlScheme='fax') then ( matches($urlStr,'^(\+?([\d()./-]|(%[a-f\d]{2}))+)*(;(phone-context=((\+?([\d()./-]|(%[a-f\d]{2}))+)|(([a-z\d-]|(%[a-f\d]{2}))+(\.([a-z\d-]|(%[a-f\d]{2}))+)*))|(ext=[\d./-]+)|(isub=(([a-z\d();/?:@&amp;=+$,_.!~*-])|(%[a-f\d]{2}))+)|([a-z\d-]+=([a-z\d\[\]/:&amp;+$_.!~*()-]|(%[a-f\d]{2}))+)))*$') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc3966)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='file') then (         matches($urlStr,'^///{0,2}((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 1738. (if ($urlScheme='file') then ( matches($urlStr,'^///{0,2}((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc1738)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='nfs') then (         matches($urlStr,'^//((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))/?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 2224. (if ($urlScheme='nfs') then ( matches($urlStr,'^//((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))/?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc2224)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='ftp' or $urlScheme='ftps') then (         matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;=~_-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z][\w-]*))?)?(/(([a-z\d$\.+!*(),?&amp;_~=-])|(%[a-f\d]{2}))*)*(;type=[aid])?$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 1738. (if ($urlScheme='ftp' or $urlScheme='ftps') then ( matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;=~_-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z][\w-]*))?)?(/(([a-z\d$\.+!*(),?&amp;_~=-])|(%[a-f\d]{2}))*)*(;type=[aid])?$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc1738)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='http' or $urlScheme='https') then (         matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*(\?(([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*(&amp;((([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*)?)*)?(#([\w~!$+|.,*:=~_]|%[a-f\d]{2})*)?$', 'i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 1738 (if ($urlScheme='http' or $urlScheme='https') then ( matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*(\?(([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*(&amp;((([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*)?)*)?(#([\w~!$+|.,*:=~_]|%[a-f\d]{2})*)?$', 'i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc1738)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='telnet') then (         matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)*$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 1738. (if ($urlScheme='telnet') then ( matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)*$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc1738)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='mailto') then (         matches($urlStr,'^[\w$\.+!*(),?&amp;~_=-]+(\.[\w$\.+!*(),?&amp;~_=-]+)*@([\w$+!*(),?&amp;~_=-]+\.)+([a-z]{2,4})$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 2368. Merk op dat het niet toegestaan is extra headers op te nemen (if ($urlScheme='mailto') then ( matches($urlStr,'^[\w$\.+!*(),?&amp;~_=-]+(\.[\w$\.+!*(),?&amp;~_=-]+)*@([\w$+!*(),?&amp;~_=-]+\.)+([a-z]{2,4})$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc2368)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='x-hl7-applicatie') then (         matches($urlStr,'^2\.16\.840\.1\.113883\.2\.4\.6\.6\.[1-9]\d+$')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten beginnen met "2.16.840.1.113883.2.4.6.6." gevolgd door een numeriek deel (if ($urlScheme='x-hl7-applicatie') then ( matches($urlStr,'^2\.16\.840\.1\.113883\.2\.4\.6\.6\.[1-9]\d+$') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='mllp') then (         matches($urlStr,'^//(([1-2]\d{0,2})(\.([1-2]\d{0,2})){3}|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2}))):(([1-9]\d{0,4})|([A-Za-z]\w*))/$')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan mllp://host:port/ waarbij 'host' een naam of IP kan zijn en 'port' een benoemde poort of een nummer (if ($urlScheme='mllp') then ( matches($urlStr,'^//(([1-2]\d{0,2})(\.([1-2]\d{0,2})){3}|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2}))):(([1-9]\d{0,4})|([A-Za-z]\w*))/$') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor and hl7:usablePeriod)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-TEL: not null and usablePeriod (not(@nullFlavor and hl7:usablePeriod) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:MCCI_IN200101/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:location"
                 priority="1000"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>Batch: <xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/device/location mag niet gebruikt worden. (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M5"/>
   <xsl:template match="@*|node()" priority="-2" mode="M5">
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>
</xsl:stylesheet>